/*
 * Decompiled with CFR 0.152.
 */
package cloud.lemonslice.teastory.blockentity;

import cloud.lemonslice.teastory.block.craft.BambooTrayMode;
import cloud.lemonslice.teastory.block.craft.CatapultBoardBlockWithTray;
import cloud.lemonslice.teastory.block.craft.IStoveBlock;
import cloud.lemonslice.teastory.client.container.BambooTrayContainer;
import cloud.lemonslice.teastory.recipe.bamboo_tray.BambooTraySingleInRecipe;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import org.jetbrains.annotations.NotNull;
import xueluoanping.teastory.block.entity.NormalContainerBlockEntity;
import xueluoanping.teastory.block.entity.SyncedBlockEntity;
import xueluoanping.teastory.registry.BlockEntityRegister;
import xueluoanping.teastory.registry.RecipeRegister;

public class BambooTrayBlockEntity
extends NormalContainerBlockEntity {
    private int processTicks = 0;
    private int totalTicks = 0;
    private int randomSeed = new Random().nextInt(943943);
    private int doubleClickTicks = 0;
    private BambooTrayMode mode = BambooTrayMode.OUTDOORS;
    private final LazyOptional<ItemStackHandler> containerInventory = LazyOptional.of(this::createHandler);
    private BambooTraySingleInRecipe currentRecipe;

    public BambooTrayBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegister.BAMBOO_TRAY_TYPE.get(), pos, state);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.containerInventory.ifPresent(h -> h.deserializeNBT((Tag)tag.m_128469_("Inv")));
        this.totalTicks = tag.m_128451_("TotalTicks");
        this.mode = BambooTrayMode.values()[tag.m_128451_("Mode")];
    }

    protected void m_183515_(CompoundTag tag) {
        this.containerInventory.ifPresent(h -> tag.m_128365_("Inv", h.serializeNBT()));
        tag.m_128405_("ProcessTicks", this.processTicks);
        tag.m_128405_("TotalTicks", this.totalTicks);
        tag.m_128405_("Mode", this.mode.ordinal());
        super.m_183515_(tag);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (!this.m_58901_() && ForgeCapabilities.ITEM_HANDLER.equals(cap)) {
            return this.containerInventory.cast();
        }
        return super.getCapability(cap, side);
    }

    public static void tick(Level worldIn, BlockPos pos, BlockState blockState, BambooTrayBlockEntity tileEntity) {
        if (tileEntity.doubleClickTicks > 0) {
            --tileEntity.doubleClickTicks;
        }
        float temp = ((Biome)tileEntity.m_58904_().m_204166_(tileEntity.m_58899_()).get()).m_47505_(tileEntity.m_58899_());
        float rainfall = ((Biome)tileEntity.m_58904_().m_204166_(tileEntity.m_58899_()).get()).getModifiedClimateSettings().f_47683_();
        switch (BambooTrayMode.getMode(tileEntity.m_58904_(), tileEntity.m_58899_())) {
            case IN_RAIN: {
                tileEntity.process((RecipeType)RecipeRegister.BAMBOO_TRAY_IN_RAIN.get(), 1.0f);
                tileEntity.mode = BambooTrayMode.IN_RAIN;
                return;
            }
            case OUTDOORS: {
                if (!tileEntity.isWorldRaining()) {
                    tileEntity.process((RecipeType)RecipeRegister.BAMBOO_TRAY_OUTDOORS.get(), 1.0f);
                }
                tileEntity.mode = BambooTrayMode.OUTDOORS;
                return;
            }
            case INDOORS: {
                tileEntity.process((RecipeType)RecipeRegister.BAMBOO_TRAY_INDOORS.get(), 1.0f);
                tileEntity.mode = BambooTrayMode.INDOORS;
                return;
            }
            case BAKE: {
                tileEntity.process((RecipeType)RecipeRegister.BAMBOO_TRAY_BAKE.get(), 1.0f);
                tileEntity.mode = BambooTrayMode.BAKE;
                return;
            }
            case PROCESS: {
                tileEntity.mode = BambooTrayMode.PROCESS;
            }
        }
    }

    private boolean process(RecipeType recipeType, float coefficient) {
        ItemStack input = this.getInput();
        if (input.m_41619_()) {
            this.setToZero();
            return false;
        }
        if (this.currentRecipe == null || !this.currentRecipe.getIngredient().test(input) || this.mode != BambooTrayMode.getMode(this.m_58904_(), this.m_58899_())) {
            this.currentRecipe = this.m_58904_().m_7465_().m_44015_(recipeType, (Container)new RecipeWrapper((IItemHandlerModifiable)this.containerInventory.resolve().get()), this.m_58904_()).orElse(null);
        }
        if (this.currentRecipe != null && !this.getOutput().m_41619_()) {
            this.refreshTotalTicks(this.currentRecipe.getWorkTime(), coefficient);
            this.processTicks = this.mode == BambooTrayMode.BAKE ? (this.processTicks += ((IStoveBlock)this.m_58904_().m_8055_(this.m_58899_().m_7495_()).m_60734_()).getFuelPower()) : ++this.processTicks;
            if (this.processTicks >= this.totalTicks) {
                ItemStack output = this.getOutput();
                output.m_41764_(input.m_41613_());
                this.containerInventory.ifPresent(inv -> inv.setStackInSlot(0, output));
                this.processTicks = 0;
                if (this.m_58900_().m_60734_() instanceof CatapultBoardBlockWithTray && this.m_58904_().m_8055_(this.m_58899_()).m_60796_((BlockGetter)this.m_58904_(), this.m_58899_())) {
                    this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)CatapultBoardBlockWithTray.ENABLED, (Comparable)Boolean.valueOf(true)));
                    CatapultBoardBlockWithTray.shoot(this.m_58904_(), this.m_58899_());
                    this.m_58904_().m_186460_(this.m_58899_(), this.m_58900_().m_60734_(), 5);
                }
                this.m_6596_();
            }
            return true;
        }
        this.setToZero();
        return false;
    }

    public ItemStack getInput() {
        return ((ItemStackHandler)this.containerInventory.orElse((Object)new ItemStackHandler())).getStackInSlot(0).m_41777_();
    }

    public ItemStack getOutput() {
        if (this.currentRecipe == null) {
            return ItemStack.f_41583_;
        }
        return this.currentRecipe.getRecipeOutput().m_41777_();
    }

    public int getTotalTicks() {
        return this.totalTicks;
    }

    public int getProcessTicks() {
        return this.processTicks;
    }

    public BambooTrayMode getMode() {
        return this.mode;
    }

    @NotNull
    public RecipeType<?> getRecipeType() {
        switch (this.mode) {
            case IN_RAIN: {
                return (RecipeType)RecipeRegister.BAMBOO_TRAY_IN_RAIN.get();
            }
            case OUTDOORS: {
                return (RecipeType)RecipeRegister.BAMBOO_TRAY_OUTDOORS.get();
            }
            case INDOORS: {
                return (RecipeType)RecipeRegister.BAMBOO_TRAY_INDOORS.get();
            }
        }
        return (RecipeType)RecipeRegister.BAMBOO_TRAY_BAKE.get();
    }

    public int getRandomSeed() {
        return this.randomSeed;
    }

    public void refreshSeed() {
        this.randomSeed = (int)(Math.random() * 10000.0);
    }

    public boolean isWorldRaining() {
        return this.m_58904_().m_46471_();
    }

    public boolean isWorking() {
        if (this.currentRecipe == null) {
            return false;
        }
        return !this.currentRecipe.getRecipeOutput().m_41619_();
    }

    public void singleClickStart() {
        this.doubleClickTicks = 10;
        this.m_6596_();
    }

    public boolean isDoubleClick() {
        return this.doubleClickTicks > 0;
    }

    private void refreshTotalTicks(int basicTicks, float coefficient) {
        this.totalTicks = (int)((float)(this.getInput().m_41613_() * basicTicks) * coefficient);
    }

    private void setToZero() {
        if (this.processTicks != 0) {
            this.processTicks = 0;
            this.m_6596_();
        }
    }

    private ItemStackHandler createHandler() {
        return new SyncedBlockEntity.SyncedItemStackHandler(this);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player p_39956_) {
        return new BambooTrayContainer(id, playerInventory, this.f_58858_, this.f_58857_);
    }
}

